--> Pralable :
/*
USE DB_INDEX;

EXEC sp_control_plan_guide @operation = N'DROP', @name = N'[PG_EMP_SRV_SEX]'
*/
--  USE DB_INDEX;

DECLARE @SQL NVARCHAR(max), @PARAMS nvarchar(max);
-- Obtention de la requte paramtre et de la liste des paramtres
EXEC sys.sp_get_query_template
N'
SELECT E.*
FROM   T_EMPLOYEE_EMP AS E
       INNER JOIN T_SERVICE_SRV AS SR
             ON E.SRV_ID = SR.SRV_ID
       INNER JOIN T_SEX AS SX
             ON E.SEX_ID = SX.SEX_ID
WHERE  SRV_LIBELLE = ''Direction''
  AND  SEX_LIBELLE = ''Femme'';
', @SQL OUTPUT, @PARAMS OUTPUT;

-- Cration dun guide de plan niveau template pour forcer le paramtrage
EXEC sys.sp_create_plan_guide
@name = N'PG_EMP_SRV_SEX_TEMPLATE',
@stmt = @SQL,
@type = N'TEMPLATE',
@params = @PARAMS,
@hints = N'OPTION(PARAMETERIZATION FORCED)';

-- Cration dun guide de plan avec des tags de table
EXEC sys.sp_create_plan_guide
@name = N'PG_EMP_SRV_SEX_SQL',
@stmt = @SQL,
@type = N'SQL',
@params = @PARAMS,
@hints = N'OPTION(TABLE HINT(E, FORCESEEK, INDEX(X_EMP_SRV, X_EMP_SRV)))';